<?php
require_once __DIR__ . '/blockchain.php';

// Example: add a “new voter” transaction
$type = $_POST['type'] ?? null;       // e.g., 'add_voter', 'add_candidate', etc.
$details = $_POST['details'] ?? null; // Should be an associative array

if (!$type || !is_array($details)) {
    die("Error: Provide 'type' and 'details' (as an associative array) via POST.");
}

$chain = new Blockchain();
$block = $chain->addTransaction($type, $details);

// Return a link that shows this block’s decrypted contents
$link = $chain->getBlockLink($block);
echo "Transaction recorded. View it here: <a href='$link'>$link</a>";
