<?php
// --- Database config ---
$host    = 'localhost';
$db      = 'vote-chain';
$user    = 'root';
$pass    = '';
$charset = 'utf8mb4';

// --- Encryption config ---
$encryption_key = 'YourStrongSecretKey123!';
$cipher_method  = 'AES-256-CBC';

// --- Encrypt ---
function encrypt($data, $key, $iv, $method) {
    return openssl_encrypt($data, $method, $key, 0, $iv);
}

// --- Decrypt ---
function decrypt($encryptedData, $key, $iv, $method) {
    return openssl_decrypt(base64_decode($encryptedData), $method, $key, 0, $iv);
}

// --- Connect to DB ---
try {
    $dsn = "mysql:host=$host;dbname=$db;charset=$charset";
    $pdo = new PDO($dsn, $user, $pass, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

// --- Sanitize Inputs ---
$phone_input  = trim($_POST['phone'] ?? '');
$id_no_input  = trim($_POST['id_no'] ?? '');
$email_input  = strtolower(trim($_POST['email'] ?? ''));
$reg_no_input = trim($_POST['reg_no'] ?? '');

$fname   = trim($_POST['fname']   ?? '');
$lname   = trim($_POST['lname']   ?? '');
$gender  = trim($_POST['gender']  ?? '');
$faculty = trim($_POST['faculty'] ?? '');

if (!$phone_input || !$id_no_input || !$email_input || !$reg_no_input || !$fname || !$lname || !$gender || !$faculty) {
    exit("Error: All fields are required.");
}

// --- Check for duplicates ---
$stmt = $pdo->query("SELECT phone, id_no, email, reg_no, iv FROM voters");
$existing = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($existing as $row) {
    $iv = base64_decode($row['iv']);
    if (
        decrypt($row['phone'], $encryption_key, $iv, $cipher_method) === $phone_input ||
        decrypt($row['id_no'], $encryption_key, $iv, $cipher_method) === $id_no_input ||
        strtolower(decrypt($row['email'], $encryption_key, $iv, $cipher_method)) === $email_input ||
        decrypt($row['reg_no'], $encryption_key, $iv, $cipher_method) === $reg_no_input
    ) {
        exit("Error: Duplicate voter found. Registration aborted.");
    }
}

// --- Encrypt fields ---
$iv        = openssl_random_pseudo_bytes(16);
$iv_base64 = base64_encode($iv);

$fname_enc   = encrypt($fname,   $encryption_key, $iv, $cipher_method);
$lname_enc   = encrypt($lname,   $encryption_key, $iv, $cipher_method);
$phone_enc   = encrypt($phone_input, $encryption_key, $iv, $cipher_method);
$faculty_enc = encrypt($faculty, $encryption_key, $iv, $cipher_method);
$id_no_enc   = encrypt($id_no_input, $encryption_key, $iv, $cipher_method);
$email_enc   = encrypt($email_input, $encryption_key, $iv, $cipher_method);
$reg_no_enc  = encrypt($reg_no_input, $encryption_key, $iv, $cipher_method);

// --- Insert into DB ---
$sql = "INSERT INTO voters (fname, lname, phone, gender, faculty, id_no, email, reg_no, iv, has_voted)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, FALSE)";
$stmt = $pdo->prepare($sql);
$stmt->execute([
    $fname_enc, $lname_enc, $phone_enc, $gender,
    $faculty_enc, $id_no_enc, $email_enc, $reg_no_enc, $iv_base64
]);

// --- Blockchain Log ---
$transaction = [
    'action' => 'Voter Registered',
    'timestamp' => time(),
    'voter_id' => $id_no_input,
    'details' => [
        'fname' => $fname_enc,
        'lname' => $lname_enc,
        'email' => $email_enc,
        'reg_no' => $reg_no_enc
    ]
];

$transaction_json = json_encode($transaction);
$transaction_hash = hash('sha256', $transaction_json);
$log_line = $transaction_hash . ' | ' . $transaction_json . PHP_EOL;

// Append to blockchain_log.txt
file_put_contents('blockchain_log.txt', $log_line, FILE_APPEND);

echo "Registration successful!";
?>
