<?php
session_start();
if (!isset($_SESSION['voter'])) die("Unauthorized");

$voter = $_SESSION['voter'];
$candidate_id = $_POST['candidate_id'];

$pdo = new PDO("mysql:host=localhost;dbname=vote-chain", "root", "", [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
]);

// Prevent double-voting
$stmt = $pdo->prepare("SELECT has_voted FROM voters WHERE id_no = ?");
$stmt->execute([$voter['id_no']]);
$row = $stmt->fetch();

if ($row['has_voted']) {
    die("You have already voted.");
}

// 1. Record the vote
$vote_time = date('Y-m-d H:i:s');
$stmt = $pdo->prepare("INSERT INTO votes (voter_id, candidate_id, vote_time) VALUES (?, ?, ?)");
$stmt->execute([$voter['id'], $candidate_id, $vote_time]);

// 2. Mark voter as having voted
$stmt = $pdo->prepare("UPDATE voters SET has_voted = 1 WHERE id = ?");
$stmt->execute([$voter['id']]);

// 3. Log vote to blockchain file (mock)
$blockchain_log = "Voter {$voter['id_no']} voted for candidate ID $candidate_id at $vote_time\n";
file_put_contents("blockchain_log.txt", $blockchain_log, FILE_APPEND);

// Clear session
session_destroy();

// 4. Show message and redirect after 2 seconds
echo "<p style='font-size:18px;color:green;'>Your vote has been submitted successfully. Redirecting...</p>";
echo "<script>
    setTimeout(function() {
        window.location.href = 'voter_login.html';
    }, 2000);
</script>";
?>
