<?php
require_once __DIR__ . '/blockchain.php';

$index = isset($_GET['index']) ? (int)$_GET['index'] : null;
if ($index === null) {
    die("No block index provided.");
}

$chain = new Blockchain();
$block = $chain->getBlockByIndex($index);

if (!$block) {
    die("Block not found.");
}

// Decrypt the payload
$decryptedJson = decryptPayload($block->data); 
$payload = json_decode($decryptedJson, true);

echo "<h2>Block #{$block->index}</h2>";
echo "<p><strong>Timestamp:</strong> {$block->timestamp}</p>";
echo "<p><strong>Previous Hash:</strong> {$block->previousHash}</p>";
echo "<p><strong>Block Hash:</strong> {$block->hash}</p>";
echo "<h3>Decrypted Transaction Details:</h3>";
echo "<pre>" . htmlentities(json_encode($payload, JSON_PRETTY_PRINT)) . "</pre>";
