<?php
$pdo = new PDO("mysql:host=localhost;dbname=vote-chain", "root", "", [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
]);

$stmt = $pdo->query("SELECT * FROM candidates");
$candidates = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>All Candidates</h2>
<table border="1">
    <tr>
        <th>Photo</th>
        <th>Name</th>
        <th>Faculty</th>
        <th>Position</th>
        <th>Actions</th>
    </tr>
    <?php foreach ($candidates as $c): ?>
        <tr>
            <td><img src="uploads/<?= htmlspecialchars($c['photo']) ?>" width="50"></td>
            <td><?= htmlspecialchars($c['full_name']) ?></td>
            <td><?= htmlspecialchars($c['faculty']) ?></td>
            <td><?= htmlspecialchars($c['position']) ?></td>
            <td>
                <a href="edit_candidate.php?id=<?= $c['id'] ?>">Edit</a> |
                <a href="delete_candidate.php?id=<?= $c['id'] ?>" onclick="return confirm('Delete this candidate?')">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
</table>
