<?php
session_start();
if (!isset($_SESSION['voter'])) die("Unauthorized.");

// Configs
$encryption_key = 'YourStrongSecretKey123!';
$cipher_method = 'AES-256-CBC';

// Decrypt function
function decrypt($data, $key, $iv, $method) {
    return openssl_decrypt($data, $method, $key, 0, $iv);
}

// DB connection
$pdo = new PDO("mysql:host=localhost;dbname=vote-chain", "root", "", [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
]);

$voter = $_SESSION['voter'];
$iv = base64_decode($voter['iv']); // decode base64 IV
$decrypted_faculty = decrypt($voter['faculty'], $encryption_key, $iv, $cipher_method);

// Fetch candidates from same faculty
$stmt = $pdo->prepare("SELECT * FROM candidates WHERE faculty = ?");
$stmt->execute([$decrypted_faculty]);
$candidates = $stmt->fetchAll();
?>

<h2>Vote for a Candidate (<?= htmlspecialchars($decrypted_faculty) ?> Faculty)</h2>
<form action="submit_vote.php" method="POST">
    <?php foreach ($candidates as $c): ?>
        <input type="radio" name="candidate_id" value="<?= $c['id'] ?>" required>
        <img src="uploads/<?= htmlspecialchars($c['photo']) ?>" width="40">
        <?= htmlspecialchars($c['full_name']) ?> (<?= htmlspecialchars($c['position']) ?>)
        <br>
    <?php endforeach; ?>
    <button type="submit">Submit Vote</button>
</form>
