<?php
session_start();

// DB & Encryption config (same as registration)
$host = 'localhost';
$db   = 'vote-chain';
$user = 'root';
$pass = '';
$charset = 'utf8mb4';

$encryption_key = 'YourStrongSecretKey123!';
$cipher_method = 'AES-256-CBC';

function decrypt($data, $key, $iv, $method) {
    return openssl_decrypt($data, $method, $key, 0, $iv);
}

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

$id_no_submitted = trim($_POST['id_no']);

if (!$id_no_submitted) {
    die("ID number is required.");
}

// Fetch all voters and their IVs (base64 encoded)
$sql = "SELECT *, iv FROM voters"; // Make sure you have an 'iv' column in voters table
$stmt = $pdo->prepare($sql);
$stmt->execute();
$voters = $stmt->fetchAll(PDO::FETCH_ASSOC);

$found_voter = null;

foreach ($voters as $voter) {
    $iv = base64_decode($voter['iv']); // decode stored IV
    
    // decrypt the id_no stored
    $id_no_decrypted = decrypt($voter['id_no'], $encryption_key, $iv, $cipher_method);
    
    if ($id_no_decrypted === $id_no_submitted) {
        $found_voter = $voter;
        break;
    }
}

if (!$found_voter) {
    die("Voter not found. Please check your ID number.");
}

if ($found_voter['has_voted']) {
    die("You have already voted.");
}

// Save voter info in session (optional: decrypt other fields here if needed)
$_SESSION['voter'] = $found_voter;

header("Location: vote_form.php");
exit;
?>

